using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;
using NAudio.Wave;

namespace AudioRecord
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            LoadMicrophones();
            checkBoxListen.CheckedChanged += CheckBoxListen_CheckedChanged;

            recordings = new List<MemoryStream>();
            isRecording = false;

            button1.Click += Button1_Click; // ʼ¼
            button2.Click += Button2_Click; // ͣ/¼
            button3.Click += Button3_Click; // ֹͣ¼

            UpdateStatus("δ¼"); // ʼ״̬

            // ע KeyDown ¼
            this.KeyDown += Form1_KeyDown;
            this.KeyUp += Form1_KeyUp;
        }

        private WaveInEvent waveIn;
        private WaveOutEvent waveOut;
        private BufferedWaveProvider waveProvider;
        private bool isRecording;
        private List<MemoryStream> recordings; // 洢¼

        private void LoadMicrophones()
        {
            int deviceCount = WaveIn.DeviceCount;
            comboBoxMicrophones.Items.Clear();

            for (int i = 0; i < deviceCount; i++)
            {
                var deviceInfo = WaveIn.GetCapabilities(i);
                comboBoxMicrophones.Items.Add($"{deviceInfo.ProductName} (Device {i})");
            }

            if (comboBoxMicrophones.Items.Count > 0)
            {
                comboBoxMicrophones.SelectedIndex = 0; // Ĭѡһ
            }
        }

        private void CheckBoxListen_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBoxListen.Checked)
            {
                StartListening();
            }
            else
            {
                StopListening();
            }
        }

        private void StartListening()
        {
            if (waveIn != null)
            {
                StopListening();
            }

            int selectedDevice = comboBoxMicrophones.SelectedIndex;
            waveIn = new WaveInEvent
            {
                WaveFormat = new WaveFormat(44100, 1) // Ƶʽ44100Hz 
            };

            waveProvider = new BufferedWaveProvider(waveIn.WaveFormat);
            waveOut = new WaveOutEvent();
            waveOut.Init(waveProvider);

            waveIn.DataAvailable += (s, e) =>
            {
                waveProvider.AddSamples(e.Buffer, 0, e.BytesRecorded);
            };

            waveIn.DeviceNumber = selectedDevice;
            waveIn.StartRecording();
            waveOut.Play();
        }

        private void StopListening()
        {
            if (waveIn != null)
            {
                waveIn.StopRecording();
                waveIn.Dispose();
                waveIn = null;
            }

            if (waveOut != null)
            {
                waveOut.Stop();
                waveOut.Dispose();
                waveOut = null;
            }
        }

        private void Button1_Click(object sender, EventArgs e)
        {
            StartRecording();
        }

        private void Button2_Click(object sender, EventArgs e)
        {
            if (isRecording)
            {
                PauseRecording();
            }
            else
            {
                ResumeRecording();
            }
        }

        private void Button3_Click(object sender, EventArgs e)
        {
            StopRecording();
        }

        private void StartRecording()
        {
            if (waveIn != null) return; // Ѿ¼򷵻

            int selectedDevice = comboBoxMicrophones.SelectedIndex;
            waveIn = new WaveInEvent
            {
                WaveFormat = new WaveFormat(44100, 1) // Ƶʽ
            };

            waveIn.DataAvailable += WaveIn_DataAvailable;
            waveIn.DeviceNumber = selectedDevice;
            waveIn.StartRecording();
            isRecording = true;

            UpdateStatus("¼"); // ״̬
        }

        private void PauseRecording()
        {
            if (waveIn != null && isRecording)
            {
                waveIn.StopRecording(); // ͣ¼
                isRecording = false;
                UpdateStatus("ͣ"); // ״̬
            }
        }

        private void ResumeRecording()
        {
            if (waveIn != null && !isRecording)
            {
                waveIn.StartRecording(); // ¼
                isRecording = true;
                UpdateStatus("¼"); // ״̬
            }
        }

        private void StopRecording()
        {
            if (waveIn != null)
            {
                waveIn.StopRecording();
                waveIn.Dispose();
                waveIn = null;

                // ¼
                SaveRecordingToDesktop();
                UpdateStatus("δ¼"); // ״̬
            }
        }

        private void WaveIn_DataAvailable(object sender, WaveInEventArgs e)
        {
            // ¼ӵ
            var recordingStream = new MemoryStream();
            recordingStream.Write(e.Buffer, 0, e.BytesRecorded);
            recordings.Add(recordingStream); // ¼
        }

        private void SaveRecordingToDesktop()
        {
            try
            {
                // ȡ·
                string desktopPath = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
                string fileName = $"Recording_{DateTime.Now:yyyyMMdd_HHmmss}.wav";
                string filePath = Path.Combine(desktopPath, fileName);

                //  WAV ļʽ
                using (var outputStream = new FileStream(filePath, FileMode.Create))
                {
                    using (var writer = new WaveFileWriter(outputStream, new WaveFormat(44100, 1)))
                    {
                        foreach (var recording in recordings)
                        {
                            recording.Position = 0; // λ
                            recording.CopyTo(writer);
                        }
                    }
                }

                MessageBox.Show($"¼ѱ浽: {fileName}");
                recordings.Clear(); // ռ¼
            }
            catch (Exception ex)
            {
                MessageBox.Show($"¼ʧ: {ex.Message}");
            }
        }

        private void UpdateStatus(string status)
        {
            label1.Text = status; //  label1 ı
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            
            // ո
            if (e.KeyCode == Keys.Space)
            {
                Button2_Click(this, EventArgs.Empty); //  Button2_Click 
                e.Handled = true; // ֹ
            }
        }

        private void Form1_KeyUp(object sender, KeyEventArgs e)
        {
            // ո̧ʱĴԲҪ߼

        }
    }
}
