﻿using System.IO;
using System;

public static class Logger
{
    private static readonly object _logLock = new object();

    public static void Log(string message)
    {
        lock (_logLock)
        {
            try
            {
                File.AppendAllText("log.txt", $"{DateTime.Now}: {message}{Environment.NewLine}");
            }
            catch (IOException ex)
            {
                // 如果文件被锁定，可以尝试其他方式（如写入临时文件）
                Console.WriteLine($"日志写入失败: {ex.Message}");
            }
        }
    }
}