﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;

namespace MES
{

    public partial class Form1 : Form
    {
        private FormResizer formResizer;
        public Form1()
        {
            InitializeComponent();
            // 设置窗体居中显示
            this.StartPosition = FormStartPosition.CenterScreen;

            // 禁止调整窗体大小
            //this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // 禁止最大化窗体
            // this.MaximizeBox = false;

            // 设置窗体标题
            this.Text = "MES维护工具";

            this.Load += new EventHandler(Form1_Load_1);
            this.SizeChanged += new EventHandler(Form1_SizeChanged);


        }
        //------------------------------------------------------------------------------------------------------------------------------------
        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                // 获取 TextBox 中的内容
                string newText = comboBox1.Text;

                // 读取原始文件内容
                string filePath = Path.Combine(Application.StartupPath, "SC_ZQMES.exe.Config");
                string fileContent = File.ReadAllText(filePath);

                string pattern = @"<add\s+key=""PAINT_MACHINE_NO""\s+value=""([^""]*)""\s*/>";
                string replacement = $@"<add key=""PAINT_MACHINE_NO"" value=""{newText}"" />";
                string modifiedContent = Regex.Replace(fileContent, pattern, replacement);

                // 将修改后的内容写回文件
                File.WriteAllText(filePath, modifiedContent);

                MessageBox.Show("文件修改成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void label1_MouseDown(object sender, EventArgs e)
        {
            try
            {
                // 获取 TextBox 中的内容
                string newText = comboBox2.Text;

                // 读取原始文件内容
                string filePath = Path.Combine(Application.StartupPath, "SC_ZQMES.exe.Config");
                string fileContent = File.ReadAllText(filePath);

                // 使用正则表达式替换文本
                string pattern = @"<add\s+key=""MACHINE_NO""\s+value=""([^""]*)""\s*/>";
                string replacement = $@"<add key=""MACHINE_NO"" value=""{newText}"" />";
                string modifiedContent = Regex.Replace(fileContent, pattern, replacement);

                // 将修改后的内容写回文件
                File.WriteAllText(filePath, modifiedContent);

                MessageBox.Show("文件修改成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            try
            {
                // 从嵌入资源中读取 DLL 文件的字节数组
                byte[] dllBytes;
                using (Stream stream = Assembly.GetExecutingAssembly().GetManifestResourceStream("MES.MQTTnet.dll"))
                {
                    if (stream == null)
                    {
                        MessageBox.Show("未找到嵌入的资源文件！");
                        return;
                    }

                    dllBytes = new byte[stream.Length];
                    stream.Read(dllBytes, 0, dllBytes.Length);
                }

                // 将 DLL 文件保存到程序所在目录
                string destinationFilePath = Path.Combine(Application.StartupPath, "MQTTnet.dll");
                File.WriteAllBytes(destinationFilePath, dllBytes);

                MessageBox.Show("DLL 文件植入成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            try
            {
                // 从嵌入资源中读取 XML 文件的字节数组
                byte[] xmlBytes;
                using (Stream stream = Assembly.GetExecutingAssembly().GetManifestResourceStream("MES.MQTTnet.xml"))
                {
                    if (stream == null)
                    {
                        MessageBox.Show("未找到嵌入的资源文件！");
                        return;
                    }

                    xmlBytes = new byte[stream.Length];
                    stream.Read(xmlBytes, 0, xmlBytes.Length);
                }

                // 将 XML 文件保存到程序所在目录
                string destinationFilePath = Path.Combine(Application.StartupPath, "MQTTnet.xml");
                File.WriteAllBytes(destinationFilePath, xmlBytes);

                MessageBox.Show("XML 文件植入成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            try
            {
                // 拼接 update.exe 文件的完整路径
                string updateExePath = Path.Combine(Application.StartupPath, "Update.exe");

                // 检查 update.exe 文件是否存在
                if (!File.Exists(updateExePath))
                {
                    MessageBox.Show("Update.exe 文件不存在！");
                    return;
                }

                // 启动 update.exe 进程
                Process.Start(updateExePath);

            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }
        private string ExecuteCommand(string command, int timeoutMilliseconds = 5000)
        {
            // 准备进程信息
            ProcessStartInfo psi = new ProcessStartInfo
            {
                FileName = "cmd.exe",
                Arguments = $"/c {command}",
                RedirectStandardOutput = true,
                UseShellExecute = false,
                CreateNoWindow = true
            };

            // 启动进程
            Process process = Process.Start(psi);
            if (!process.WaitForExit(timeoutMilliseconds))
            {
                // 如果超时，终止进程
                process.Kill();
                return "获取.Net版本号失败！";
            }
            // 读取输出结果
            string output = process.StandardOutput.ReadToEnd().Trim();
            process.WaitForExit();
            
            return output;
        }
        //-------------------------------------------------------------------------------------------------------------------------
        private void Form1_Load_1(object sender, EventArgs e)
        {
            // 执行命令并读取输出结果
            string dotnetVersion = ExecuteCommand("dotnet --version");

            // 将输出结果显示在 Label 控件中
            label5.Text = "本地.NET 版本：" + dotnetVersion + "  （如未显示请检查SDK）";

            // 设置超链接的起始位置和长度
            linkLabel1.LinkArea = new LinkArea(0, 7); // 从索引0开始，长度为7个字符

            // 设置超链接的行为为打开 URL
            linkLabel1.LinkBehavior = LinkBehavior.HoverUnderline;

            // 设置超链接的目标 URL
            linkLabel1.Links[0].LinkData = "http://10.151.12.70:8080/pda";

            // 设置超链接的起始位置和长度
            linkLabel2.LinkArea = new LinkArea(0, 7); // 从索引0开始，长度为7个字符

            // 设置超链接的行为为打开 URL
            linkLabel2.LinkBehavior = LinkBehavior.HoverUnderline;

            // 设置超链接的目标 URL
            linkLabel2.Links[0].LinkData = "http://10.151.12.70:8080/log";

            formResizer = new FormResizer(this);


        }
        //------------------------------------------------------------------------------------------------------------------------
        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            // 获取超链接的目标 URL
            string url = (string)e.Link.LinkData;

            // 打开默认浏览器访问 URL
            System.Diagnostics.Process.Start(url);
        }

        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            // 获取超链接的目标 URL
            string url = (string)e.Link.LinkData;

            // 打开默认浏览器访问 URL
            System.Diagnostics.Process.Start(url);
        }

        private void button6_Click(object sender, EventArgs e)
        {
            Form2 form2 = new Form2();

            // 显示第二个窗体
            form2.Show();
        }

        private void button7_Click(object sender, EventArgs e)
        {
            string fileName = "SC_ZQMES.exe.Config";
            string path = System.IO.Path.Combine(Application.StartupPath, fileName);
            try
            {
                Process.Start(path);
            }
            catch (Exception ex)
            {
                MessageBox.Show("无法打开文件: " + ex.Message);
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            Form3 form3 = new Form3();

            // 显示第二个窗体
            form3.Show();
        }

        private void button9_Click(object sender, EventArgs e)
        {
            
            // 检查是否有名为 "SC_ZQMES.exe" 的进程在运行
            Process[] processes = Process.GetProcessesByName("SC_ZQMES");
            

            if (processes.Length > 0)
            {
                // 如果已经运行，则关闭所有名为 "SC_ZQMES.exe" 的进程
                foreach (Process process in processes)
                {
                    process.Kill();
                }


                // 打开一个新的 SC_ZQMES.exe 进程
                Process.Start("SC_ZQMES.exe");
              
            }
            else
            {
                // 如果没有运行，则直接打开 SC_ZQMES.exe
                Process.Start("SC_ZQMES.exe");
              
            }
        }

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            if (formResizer != null)
            {
                formResizer.ResizeControls(this);
            }
        }
        

        //------------------------------------------------------------------------------------------------------------------------
    }
    public class ControlInfo
    {
        public Rectangle Bounds { get; set; }
        public float FontSize { get; set; }
    }
}


