﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace MES
{
    public partial class Form2 : Form
    {
        private FormResizer formResizer;
        public Form2()
        {
            InitializeComponent();
            this.StartPosition = FormStartPosition.CenterScreen;

            // 禁止调整窗体大小
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // 禁止最大化窗体
            this.MaximizeBox = true;

            // 设置窗体标题
            this.Text = "计量仪器维护";

            this.Load += new EventHandler(Form2_Load);
            this.SizeChanged += new EventHandler(Form2_SizeChanged);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                // 获取 TextBox 中的内容
                string newText = comboBox1.Text;

                // 读取原始文件内容
                string filePath = Path.Combine(Application.StartupPath, "SC_ZQMES.exe.Config");
                string fileContent = File.ReadAllText(filePath);

                string pattern = @"<add\s+key=""EBALANCE_COM""\s+value=""([^""]*)""\s*/>";
                string replacement = $@"<add key=""EBALANCE_COM"" value=""{newText}"" />";
                string modifiedContent = Regex.Replace(fileContent, pattern, replacement);

                // 将修改后的内容写回文件
                File.WriteAllText(filePath, modifiedContent);

                MessageBox.Show("COM口修改成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            try
            {
                // 获取 TextBox 中的内容
                string newText = comboBox2.Text;

                // 读取原始文件内容
                string filePath = Path.Combine(Application.StartupPath, "SC_ZQMES.exe.Config");
                string fileContent = File.ReadAllText(filePath);

                string pattern = @"<add\s+key=""EBALANCE_COM_RATE""\s+value=""([^""]*)""\s*/>";
                string replacement = $@"<add key=""EBALANCE_COM_RATE"" value=""{newText}"" />";
                string modifiedContent = Regex.Replace(fileContent, pattern, replacement);

                // 将修改后的内容写回文件
                File.WriteAllText(filePath, modifiedContent);

                MessageBox.Show("波特率修改成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            try
            {
                // 获取 TextBox 中的内容
                string newText = comboBox4.Text;

                // 读取原始文件内容
                string filePath = Path.Combine(Application.StartupPath, "SC_ZQMES.exe.Config");
                string fileContent = File.ReadAllText(filePath);

                string pattern = @"<add\s+key=""EGO_COM""\s+value=""([^""]*)""\s*/>";
                string replacement = $@"<add key=""EGO_COM"" value=""{newText}"" />";
                string modifiedContent = Regex.Replace(fileContent, pattern, replacement);

                // 将修改后的内容写回文件
                File.WriteAllText(filePath, modifiedContent);

                MessageBox.Show("COM口修改成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            try
            {
                // 获取 TextBox 中的内容
                string newText = comboBox3.Text;

                // 读取原始文件内容
                string filePath = Path.Combine(Application.StartupPath, "SC_ZQMES.exe.Config");
                string fileContent = File.ReadAllText(filePath);

                string pattern = @"<add\s+key=""EGO_COM_RATE""\s+value=""([^""]*)""\s*/>";
                string replacement = $@"<add key=""EGO_COM_RATE"" value=""{newText}"" />";
                string modifiedContent = Regex.Replace(fileContent, pattern, replacement);

                // 将修改后的内容写回文件
                File.WriteAllText(filePath, modifiedContent);

                MessageBox.Show("波特率修改成功！");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            try
            {
                // 从嵌入资源中读取 EXE 文件的字节数组
                byte[] exeBytes;
                using (Stream stream = Assembly.GetExecutingAssembly().GetManifestResourceStream("MES.USR-TCP232-Test-V1.3.exe"))
                {
                    if (stream == null)
                    {
                        MessageBox.Show("未找到嵌入的资源文件！");
                        return;
                    }

                    exeBytes = new byte[stream.Length];
                    stream.Read(exeBytes, 0, exeBytes.Length);
                }

                // 将 EXE 文件保存到临时文件
                string tempFilePath = Path.Combine(Path.GetTempPath(), "EmbeddedProgram.exe");
                File.WriteAllBytes(tempFilePath, exeBytes);

                // 启动临时文件
                Process.Start(tempFilePath);
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            try
            {
                // 启动设备管理器
                Process.Start("devmgmt.msc");
            }
            catch (Exception ex)
            {
                MessageBox.Show("发生错误：" + ex.Message);
            }
        }

        private void Form2_Load(object sender, EventArgs e)
        {
            formResizer = new FormResizer(this);
        }

        private void Form2_SizeChanged(object sender, EventArgs e)
        {
            if (formResizer != null)
            {
                formResizer.ResizeControls(this);
            }
        }
    }
}
