﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Reflection.Emit;
using System.Text;
using System.Windows.Forms;

namespace MES
{
    public partial class Form5 : Form
    {
        public Form5()
        {
            InitializeComponent();
            // 设置窗体居中显示
            this.StartPosition = FormStartPosition.CenterScreen;

            // 禁止调整窗体大小
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // 禁止最大化窗体
            this.MaximizeBox = false;

            // 设置窗体标题
            this.Text = "管理员窗口（窗口在一分钟内未操作将会关闭）";
            // 启动定时器
            timer1 = new Timer();
            timer1.Interval = 1 * 60 * 1000; // 1 分钟
            timer1.Tick += Timer_Tick;
            timer1.Start();
        }
        private void Timer_Tick(object sender, EventArgs e)
        {
            // 关闭窗体
            this.Close();
        }
        private void ResetTimer()
        {
            timer1.Stop(); // 先停止定时器
            timer1.Start(); // 再重新启动定时器
        }
        private void button1_Click(object sender, EventArgs e)
        {
            string networkPath = @"\\10.151.12.51";

            try
            {
                using (Process explorerProcess = new Process())
                {
                    explorerProcess.StartInfo.FileName = "explorer.exe";
                    explorerProcess.StartInfo.Arguments = networkPath;

                    // 设置超时时间为3秒
                    explorerProcess.StartInfo.UseShellExecute = false;
                    explorerProcess.Start();
                    explorerProcess.WaitForExit(3000); // 等待3秒

                    // 如果超时退出则提示路径未找到
                    if (!explorerProcess.HasExited)
                    {
                        explorerProcess.Kill(); // 终止进程
                        MessageBox.Show("未找到公盘路径或网络未响应！");
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show($"发生错误：{ex.Message}");
            }
            ResetTimer();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            label3.Text = textBox1.Text;
            UpdateConfiguration("Diskusername", label3.Text);
            // 生成随机字符串
            string randomString = GenerateRandomString(99);

            // 要写入配置文件的值
            string valueToWrite = label3.Text + randomString;

            // 更新配置文件中的值
            UpdateConfiguration("Diskuserpassword", valueToWrite);

            // 重置定时器
            ResetTimer();
        }

        private void Form5_Load(object sender, EventArgs e)
        {
            // 从配置文件中读取键值对的值
            string value = ConfigurationManager.AppSettings["Diskuserpassword"];

            // 如果值不为空且长度大于等于99，则去掉最后99位字符
            if (!string.IsNullOrEmpty(value) && value.Length >= 99)
            {
                value = value.Substring(0, value.Length - 99);
            }
            // 在 Label 中显示处理后的值
            label4.Text = value;
            // 从配置文件中读取保存的文本内容并设置到 Label 中
            label3.Text = ConfigurationManager.AppSettings["Diskusername"];
        }

        private string GenerateRandomString(int length)
        {
            Random random = new Random();
            const string chars = "abcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+{}?";
            return new string(Enumerable.Repeat(chars, length)
              .Select(s => s[random.Next(s.Length)]).ToArray());
        }
        private void UpdateConfiguration(string key, string value)
        {
            Configuration configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
            configuration.AppSettings.Settings[key].Value = value;
            configuration.Save(ConfigurationSaveMode.Modified);
            ConfigurationManager.RefreshSection("appSettings");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            label4.Text = textBox2.Text;
            // 生成随机字符串
            string randomString = GenerateRandomString(99);

            // 要写入配置文件的值
            string valueToWrite = label4.Text + randomString;

            // 更新配置文件中的值
            UpdateConfiguration("Diskuserpassword", valueToWrite);

            // 重置定时器
            ResetTimer();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            // 复制 label3 的文本到剪贴板
            Clipboard.SetText(label3.Text);
            ResetTimer();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            // 复制 label4 的文本到剪贴板
            Clipboard.SetText(label4.Text);
            ResetTimer();
        }

        private void wwwao1ckjzfkwnetToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // 指定要打开的网页 URL
            string url = "http://www.ao1ck.jzfkw.net";

            // 打开默认浏览器并导航到指定的 URL
            Process.Start(url);
        }
    }
}
