﻿using System;
using System.Collections.Generic;
using System.Drawing.Drawing2D;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;

namespace MES
{
   
    public class CircularButton : Button
        {
            protected override void OnPaint(PaintEventArgs e)
            {
                base.OnPaint(e);

                // 获取按钮的绘图对象
                Graphics g = e.Graphics;

                // 清除原有的绘制
                g.Clear(this.BackColor);

                // 计算圆形按钮的位置和大小
                int diameter = Math.Min(this.Width, this.Height);
                int x = (this.Width - diameter) / 2;
                int y = (this.Height - diameter) / 2;

                // 创建圆形路径
                GraphicsPath path = new GraphicsPath();
                path.AddEllipse(x, y, diameter, diameter);

                // 将按钮的形状设置为圆形
                this.Region = new Region(path);

                // 绘制圆形按钮的边框
                using (Pen pen = new Pen(this.ForeColor, 2))
                {
                    g.DrawEllipse(pen, x, y, diameter, diameter);
                }
            }
        }
    }
