﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Reflection.Emit;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace Methorlink
{
    public partial class Form1 : Form
    {
        private int mouseX, mouseY;
        private bool isDragging = false;
        private Process consoleProcess;
        private IntPtr consoleWindowHandle = IntPtr.Zero;
        [DllImport("user32.dll")]
        private static extern IntPtr FindWindow(string lpClassName, string lpWindowName);
        [DllImport("user32.dll")]
        private static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);
        private const int SW_HIDE = 0;
        private const int SW_SHOW = 5;


        public Form1()
        {
            InitializeComponent();
            this.WindowState = FormWindowState.Minimized; // 设置窗体初始状态为最小化
            this.FormBorderStyle = FormBorderStyle.None;
            this.StartPosition = FormStartPosition.CenterScreen;
            timer1 = new Timer();// 创建定时器
            timer1.Interval = 5000; // 5秒
            timer1.Tick += Timer1_Tick;
            timer1.Enabled = false; // 默认未启用
        }
        #region formmove
        private void panel1_MouseMove(object sender, MouseEventArgs e)
        {
            if (isDragging)
            {
                this.Left += e.X - mouseX;
                this.Top += e.Y - mouseY;
            }
        }

        private void panel1_MouseUp(object sender, MouseEventArgs e)
        {
            isDragging = false;
        }

        private void panel1_MouseDown(object sender, MouseEventArgs e)
        {
            isDragging = true;
            mouseX = e.X;
            mouseY = e.Y;
        }
        #endregion

        #region topbutton
        private void pictureBox1_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button10_Click(object sender, EventArgs e)
        {
            this.Hide();
            notifyIcon1.Visible = true;
        }
        private void Form1_Resize(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {
                this.Hide();
                notifyIcon1.Visible = true;
            }
        }
        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.Show();
            this.WindowState = FormWindowState.Normal;
            notifyIcon1.Visible = false;
        }
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (notifyIcon1 != null)
            {
                notifyIcon1.Visible = false;
                notifyIcon1.Dispose();
            }
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            this.Hide();
            notifyIcon1.Visible = true;
        }
        #endregion

        #region release files
        private void button1_Click(object sender, EventArgs e)
        {
            // 目标文件夹路径
            string targetFolder = @"C:\method";

            // 检查并创建目标文件夹
            if (!Directory.Exists(targetFolder))
            {
                Directory.CreateDirectory(targetFolder);
            }

            // 获取当前程序集
            Assembly assembly = Assembly.GetExecutingAssembly();

            // 获取所有嵌入的资源名称
            string[] resourceNames = assembly.GetManifestResourceNames();

            // 提取并保存每个资源
            foreach (string resourceName in resourceNames)
            {
                // 读取资源流
                using (Stream resourceStream = assembly.GetManifestResourceStream(resourceName))
                {
                    if (resourceStream != null)
                    {
                        // 获取第二个点号的位置
                        int firstDotIndex = resourceName.IndexOf('.');
                        int secondDotIndex = resourceName.IndexOf('.', firstDotIndex + 1);

                        // 提取第二个点号后的文件名
                        string fileName = resourceName.Substring(secondDotIndex + 1);
                        string filePath = Path.Combine(targetFolder, fileName);

                        // 将资源写入文件
                        using (FileStream fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                        {
                            CopyStream(resourceStream, fileStream);
                        }
                    }
                }
            }

            MessageBox.Show("Resources extracted successfully!");
        }

      

        // 手动实现的CopyTo方法
        private void CopyStream(Stream input, Stream output)
        {
            byte[] buffer = new byte[81920];
            int bytesRead;
            while ((bytesRead = input.Read(buffer, 0, buffer.Length)) > 0)
            {
                output.Write(buffer, 0, bytesRead);
            }
        }
        #endregion

        #region ctl btn
        private void button2_Click(object sender, EventArgs e)
        {
            // 配置文件路径
            string configFilePath = @"C:\method\config.json";

            // 检查文件是否存在
            if (File.Exists(configFilePath))
            {
                // 使用记事本打开配置文件
                Process.Start("notepad.exe", configFilePath);
            }
            else
            {
                MessageBox.Show("Config file not found.");
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            // 配置文件路径
            string configFilePath = @"C:\method\client.ini";

            // 检查文件是否存在
            if (File.Exists(configFilePath))
            {
                // 使用记事本打开配置文件
                Process.Start("notepad.exe", configFilePath);
            }
            else
            {
                MessageBox.Show("Config file not found.");
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            // 获取当前程序的可执行文件路径
            string exePath = Application.ExecutablePath;

            // 注册表项路径
            string registryKeyPath = @"SOFTWARE\Microsoft\Windows\CurrentVersion\Run";

            // 打开注册表项
            using (RegistryKey key = Registry.CurrentUser.OpenSubKey(registryKeyPath, true))
            {
                if (key != null)
                {
                    // 添加或更新注册表项，将"methorlink"替换为你的程序名称
                    key.SetValue("methorlink", exePath);
                    MessageBox.Show("Application added to startup successfully!");
                }
                else
                {
                    MessageBox.Show("Failed to open registry key.");
                }
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            // 注册表项路径
            string registryKeyPath = @"SOFTWARE\Microsoft\Windows\CurrentVersion\Run";

            // 打开注册表项
            using (RegistryKey key = Registry.CurrentUser.OpenSubKey(registryKeyPath, true))
            {
                if (key != null)
                {
                    // 检查注册表项是否存在
                    if (key.GetValue("methorlink") != null)
                    {
                        // 删除注册表项
                        key.DeleteValue("methorlink");
                        MessageBox.Show("Application removed from startup successfully!");
                    }
                    else
                    {
                        MessageBox.Show("Application is not in startup.");
                    }
                }
                else
                {
                    MessageBox.Show("Failed to open registry key.");
                }
            }
        }

        private void Timer1_Tick(object sender, EventArgs e)
        {
            CheckProcesses();
        }
        private void CheckProcesses()
        {
            if (!IsProcessRunning("frpc") || !IsProcessRunning("v2ray"))
            {
                Reclick();
            }
        }
        private bool IsProcessRunning(string processName)
        {
            Process[] processes = Process.GetProcessesByName(processName);
            return processes.Length > 0;
        }
        private void Reclick()
        {
            // 模拟点击按钮6和按钮7
            button6_Click(null, EventArgs.Empty);
            button7_Click(null, EventArgs.Empty);
        }
        private void button6_Click(object sender, EventArgs e)
        {
            consoleProcess = new Process();
            consoleProcess.StartInfo.FileName = @"C:\method\v2ray.exe";
            consoleProcess.StartInfo.UseShellExecute = false;
            consoleProcess.StartInfo.CreateNoWindow = true;
            consoleProcess.Start();
        }

       

        private void button7_Click(object sender, EventArgs e)
        {          
                string batchFilePath = @"C:\method\frpcstart.bat"; // 批处理文件路径
                string batchFileDirectory = Path.GetDirectoryName(batchFilePath);
                consoleProcess = new Process();
                consoleProcess.StartInfo.FileName = "cmd.exe";
                consoleProcess.StartInfo.Arguments = $"/c \"{batchFilePath}\"& pause"; // 使用 /c 执行并关闭窗口
                consoleProcess.StartInfo.WorkingDirectory = batchFileDirectory;
                consoleProcess.StartInfo.UseShellExecute = false;
                consoleProcess.StartInfo.CreateNoWindow = true;
                consoleProcess.Start();

                // 等待控制台窗口创建
                System.Threading.Thread.Sleep(500); // 确保窗口已创建，必要时调整时间

                // 获取控制台窗口句柄
                consoleWindowHandle = FindWindow(null, consoleProcess.MainWindowTitle);          
        }

        private void button9_Click(object sender, EventArgs e)
        {
            timer1.Stop();
            MessageBox.Show("循环控制结束");
        }

        private void button8_Click(object sender, EventArgs e)
        {
            timer1.Start();
            MessageBox.Show("循环控制开始");
        }

        private void button11_Click(object sender, EventArgs e)
        {
            EndProcessByName("v2ray");
            EndProcessByName("frpc");
        }

        private void EndProcessByName(string processName)
        {
            Process[] processes = Process.GetProcessesByName(processName);
            foreach (Process process in processes)
            {
                process.Kill(); // 结束进程
            }
        }
        #endregion

    }
}
